package de.bebagoe.util.strings;

import java.util.*;

public class StringUtil {
	final static int NCOL_DEF = 72;
	final static String DELIM_DEF = " \t\n\r\f-";

	public static void wrapln(CharSequence text, CharSequence delim, int ncol) {
		var token = new StringBuilder();
		var zeile = new StringBuilder();
		java.util.StringTokenizer stok = new java.util.StringTokenizer(text.toString(), delim.toString(), true);

		while (stok.hasMoreTokens()) {
			token.replace(0, token.length(), stok.nextToken());

			// Nach einem Zeilentrennzeichen wird der aktuelle Text ausgegeben und eine neue Zeile begonnen.
			if (isLineSep(token.charAt(0))) {
				write(zeile);
				zeile.delete(0, zeile.length());
				continue;
			}

			if (zeile.length() + token.length() <= ncol) {
				zeile.append(token);
			} else {
				write(zeile);
				while (token.length() > ncol) {
					zeile.replace(0, zeile.length(), token.substring(0, ncol));
					write(zeile);
					token.delete(0, ncol);
				}
				zeile.replace(0, zeile.length(), token.toString());
			}
		}
		write(zeile);
	}

	private static boolean isLineSep(char c) {
        return c == '\n' || c == '\r' || c == '\f';
	}

	private static void write(StringBuilder zeile) {
		while (!zeile.isEmpty() && zeile.charAt(0) == ' ')
			zeile.deleteCharAt(0);
		if (!zeile.isEmpty())
			IO.println(zeile);
	}

	public static void wrapln(CharSequence  text, int ncol) {
		wrapln(text, DELIM_DEF, ncol);
	}

	public static void wrapln(CharSequence  text) {
		wrapln(text, DELIM_DEF, NCOL_DEF);
	}

	public static List<String> getWordList(CharSequence text, CharSequence delim) {
		if (text == null || text.isEmpty())
			return null;
		List<String> words = new ArrayList<>();
		java.util.StringTokenizer stok = new java.util.StringTokenizer(text.toString(), delim.toString(), false);
		while (stok.hasMoreTokens())
			words.add(stok.nextToken());
		return words;
	}	

	public static List<String> getWordList(CharSequence text) {
		return getWordList(text, DELIM_DEF);
	}
	
	public static NavigableMap<Character,Integer> getStartCharFreqs(CharSequence text, CharSequence delim) {
		List<String> words = getWordList(text, delim);
		TreeMap<Character, Integer> startCharFeqs = new TreeMap<>();
		if (words.isEmpty())
			return startCharFeqs;

		// Das Sortieren hilft, häufiges Auto(un)boxing mit Integer zu vermeiden.
		words.sort(String.CASE_INSENSITIVE_ORDER);
		Iterator<String> its = words.iterator();
		char currentChar = Character.toLowerCase(its.next().charAt(0));
		int currentCharFreq = 1;
		char newChar;
		while (its.hasNext()) {
			newChar = Character.toLowerCase(its.next().charAt(0));
			if (newChar == currentChar) {
				currentCharFreq++;
			} else {
				startCharFeqs.put(currentChar, currentCharFreq);
				currentChar = newChar;
				currentCharFreq = 1;
			}
		}
		startCharFeqs.put(currentChar, currentCharFreq);
		return startCharFeqs;
	}
	
	public static NavigableMap<Character,Integer> getStartCharFreqs(CharSequence text) {
		return getStartCharFreqs(text, DELIM_DEF);
	}
}
